<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('first_name', 'last_name', 'user_name', 'email', 'password', 'legacy_user_id', 'contact_number', 'user_type', 'disabled', 'source', 'import_version', 'whitelist_ips');

    public function previousPasswords()
    {
        return $this->hasMany('App\Models\UserPasswordHistory');
    }

    public function facilities()
    {
        return $this->hasMany('App\Models\UserFacility');
    }

    public function assessments()
    {
        return $this->hasMany('App\Models\Assessment');
    }

}